class Solution {
    public int minMalwareSpread(int[][] graph, int[] initial) {
        
        //we need to find a node whoose removal lead to increase no of connected components 
        
        int nodes = graph.length;
        
        //mark nodes which are not malware
        boolean isNodeInfected[] = new boolean [nodes + 1];
        for (int infectedNode: initial)
            isNodeInfected[infectedNode] = true;
        
        Map<Integer, List<Integer>> mapOfNonInfectedToInfectedMap = new HashMap<>();
        //Now perform dfs on infectedNodes and visited components
        for (int infectedNode: initial) {
            Set<Integer> seen = new HashSet<>();
            dfs(infectedNode, graph, mapOfNonInfectedToInfectedMap, isNodeInfected, seen, infectedNode);
        }
    
        int countOfUniquelyInfectedNodes[] = new int[nodes + 1];
        for(Map.Entry<Integer, List<Integer>> entry: mapOfNonInfectedToInfectedMap.entrySet()) {
            if(entry.getValue().size() == 1)
                countOfUniquelyInfectedNodes[entry.getValue().get(0)]++;
        }
        
        Arrays.sort(initial);
        
        int currentMax = Integer.MIN_VALUE;
        int ans = -1;
        for (int infectedNode: initial) {
            if(countOfUniquelyInfectedNodes[infectedNode] > currentMax) {
                currentMax = countOfUniquelyInfectedNodes[infectedNode] ;
                ans = infectedNode;
            }
        }  
        return ans;  
    }
    //dfs
    public void dfs(int infectedNode, int graph[][], Map<Integer, List<Integer>> mapOfNonInfectedToInfectedMap, boolean isNodeInfected[], Set<Integer> seen, int rootedInfectedNode) {
        
        seen.add(infectedNode);
        for (int i = 0; i < graph[infectedNode].length; i++) {
            if(!isNodeInfected[i] && graph[infectedNode][i] == 1 && !seen.contains(i)) {
                List<Integer> infectedParents = mapOfNonInfectedToInfectedMap.getOrDefault(i, new ArrayList<Integer>());
                infectedParents.add(rootedInfectedNode);
                mapOfNonInfectedToInfectedMap.put(i, infectedParents);
                dfs(i, graph, mapOfNonInfectedToInfectedMap, isNodeInfected, seen, rootedInfectedNode);
            }
        } 
    }
    
    //dsu
    //graph coloring
    
}
